#!/usr/bin/perl
#
# BlueLava v0.4.3
# (c) 2001-2004  Ian Wilkinson (ian@sgtwilko.f9.co.uk)
#
# Released under the GPL v2... see COPYING for details
# This software comes without any warranty...
#


sub save_Configuration{
	if (!open (CONFIGFILE, ">bluelava.conf"))
	{
		html_notice("Error Opening Configuration File", "The BlueLava configuration file, bluelava.conf, could not be opened for writing.<br>Please check that your webserver user has write access to the bluelava.conf.<br>If in doubt please run:<br><center> <code>chmod a+rw bluelava.conf</code></center><br>from the bluelava directory.", "#FFFFFF", "#FF0000"); 	
		exit(0);
	}
	print CONFIGFILE "#BlueLava config file\n";
	foreach $Config (keys %config_settings)
	{
		if ( !($Config eq "defined")) {
			print CONFIGFILE "$Config\t\"$config_settings{\"$Config\"}\"\n";
		}
	}
	print CONFIGFILE "\n#Room and Device Configuration\n";
	foreach $room (keys %config_rooms)
	{
		$deviceptr = $config_rooms{$room};
		print CONFIGFILE "\nroom \"$room\"\n";
		@devicelist = @$deviceptr;
		foreach $device (@devicelist)
		{
			%devicehash = %$device;
			print CONFIGFILE "device\t\"$devicehash{\"id\"}\"\t\"$devicehash{\"type\"}\"\t\"$devicehash{\"name\"}\"\n";
		}
	}
	close (CONFIGFILE);
} 

1;
